/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search;

import com.arsdigita.initializer.Configuration;
import com.arsdigita.initializer.InitializationException;

import com.arsdigita.domain.GlobalObserverManager;

import org.apache.log4j.Logger;

/**
 * This initializer (which will soon go away) activates
 * the appropriate search engine.
 * There are no APIs intended for public use in this class
 */
public class Initializer
    implements com.arsdigita.initializer.Initializer {

    private Configuration m_conf = new Configuration();

    private static final Logger s_log =
        Logger.getLogger(Initializer.class);

    public Initializer() throws InitializationException {
    }

    public Configuration getConfiguration() {
        return m_conf;
    }

    public void startup() {
        if (Search.getConfig().getIndexerType().getObserver() != null) {
            s_log.info("registering observer for indexer: " + Search.getConfig().getIndexerType());
            GlobalObserverManager gom = GlobalObserverManager.getManager();
            gom.addObserver(new SearchObserver());
        } else {
            s_log.info("Not registering a search observer");
        }
        
    }

    public void shutdown() {}

}
