/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search;


/**
 * A class to represent the different types of content
 * that can be indexed
 */
public class ContentType {
    
    private String m_name;

    private ContentType(String name) {
        m_name = name;
    }
    
    public String toString() {
        String base = super.toString();
        return base + " (name: " + m_name + ")";
    }

    /**
     * Constant for Raw content
     */
    public static final ContentType RAW = new ContentType("raw");
    
    /**
     * Constant for XML content
     */
    public static final ContentType XML = new ContentType("xml");

    /**
     * Constant for plain text content
     */
    public static final ContentType TEXT = new ContentType("text");
}
