/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search;

import com.arsdigita.domain.DomainObject;

/**
 * This interface is the API through which a domain
 * object provides its searchable content. Content
 * can be provided in one of (currently) 3 formats,
 * plain text, XML, and RAW binary. Implementors
 * should query the SearchConfig class to determine
 * which formats are supported by the current indexer
 *
 * @see com.arsdigita.search.MetadataProvider
 * @see com.arsdigita.search.SearchConfig
 */
public interface ContentProvider {
    
    /**
     * Returns a 'context' tag for this block of
     * content. This may be interpreted by the 
     * search engine implementations
     */
    String getContext();
    
    /**
     * Returns the type of this contnet, one of
     * the constants defined in the Search class
     *
     * @param dobj the domain object
     */
    ContentType getType();

    // XXX force all types to use byte ?
    // or use subclassing instead ?
    /**
     * Returns the actual content for the object
     *
     * @param dobj the domain object
     * @return byte array representing the text,
     * xml or raw contnet
     */
    byte[] getBytes();

}
