/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.runtime;

import com.arsdigita.util.parameter.ParameterContext;

/**
 * The Script interface provides an extension point for CCM Developers
 * to write paramaterizable chunks of code intended for execution in
 * various contexts. The Script interface builds on the {@link
 * com.arsdigita.util.parameter parameter} system in order to allow a
 * context independent means for Script implementers to access
 * parameter values. Implementors of the Script interface should
 * extend the {@link AbstractScript} class.
 *
 * @author Rafael H. Schloming &lt;rhs@mit.edu&gt;
 * @version $Revision: #5 $ $Date: 2004/04/07 $
 **/

public interface Script extends ParameterContext {

    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/runtime/Script.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * This method is invoked in order to execute the script. The
     * implementor of the script should use the persistent session
     * provided by the given ScriptContext.
     *
     * @param context The context in which the script is to execute.
     **/

    public void run(ScriptContext context);

}
