/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.runtime;

import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.util.parameter.ErrorList;
import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.ParameterInfo;
import com.arsdigita.util.parameter.ParameterLoader;
import com.arsdigita.util.parameter.ParameterValue;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Iterator;

/**
 * InteractiveParameterLoader
 *
 * @deprecated
 *
 * @author Rafael H. Schloming &lt;rhs@mit.edu&gt;
 * @version $Revision: #6 $ $Date: 2004/04/07 $
 **/

public final class InteractiveParameterLoader implements ParameterLoader {

    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/runtime/InteractiveParameterLoader.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private final InputStream m_in;
    private final PrintStream m_out;
    private final BufferedReader m_lines;

    public InteractiveParameterLoader(InputStream in, PrintStream out) {
        m_in = in;
        m_out = out;
        m_lines = new BufferedReader(new InputStreamReader(m_in));
    }

    public final String read(final Parameter param, final ErrorList errors) {
        if (!param.isRequired()) { return null; }
        final Object dephault = param.getDefaultValue();
        if (dephault != null) { return null; }

        m_out.println("Parameter: " + param.getName());

        final ParameterInfo info = param.getInfo();

        if (info != null) {
            String str = info.getTitle();
            if (str != null) {
                m_out.println("Title: " + str);
            }
            str = info.getPurpose();
            if (str != null) {
                m_out.println("Purpose: " + str);
            }
            str = info.getExample();
            if (str != null) {
                m_out.println("Example: " + str);
            }
            str = info.getFormat();
            if (str != null) {
                m_out.println("Format: " + str);
            }
        }

        while (true) {
            m_out.print("Value: ");
            m_out.flush();

            try {
                final String line = m_lines.readLine();

                if (line.equals("")) {
                    continue;
                } else {
                    return line;
                }
            } catch (IOException e) {
                throw new UncheckedWrapperException(e);
            }
        }
    }

    public ParameterValue load(Parameter param) {
        final ParameterValue value = new ParameterValue();
        value.setObject(param.read(this, value.getErrors()));
        param.validate(value.getObject(), value.getErrors());

        final ErrorList errs = value.getErrors();

        if (errs.isEmpty()) {
            return value;
        }

        for (Iterator it = errs.iterator(); it.hasNext(); ) {
            m_out.println(it.next());
        }

        return null;
    }
}
