/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.runtime;

import com.arsdigita.persistence.pdl.PDLCompiler;

/**
 * A DataInitEvent is passed to the {@link
 * Initializer#init(DataInitEvent)} method in order to provide the
 * target Initializer access to the objects necessary to properly
 * initialize the data layer.
 *
 * @author Rafael Schloming &lt;rhs@mit.edu&gt;
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //core-platform/dev/src/com/arsdigita/runtime/DataInitEvent.java#5 $
 */
public final class DataInitEvent {
    public final static String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/runtime/DataInitEvent.java#5 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private final PDLCompiler m_compiler;

    DataInitEvent(final PDLCompiler compiler) {
        m_compiler = compiler;
    }

    /**
     * Returns an instance of a PDLCompiler object that may be used to
     * parse PDL.
     *
     * @return a PDLCompiler
     *
     * @see com.arsdigita.persistence.pdl.PDLSource
     **/

    public final PDLCompiler getCompiler() {
        return m_compiler;
    }

}
