/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.portal.apportlet;

import com.arsdigita.bebop.portal.AbstractPortletRenderer;
import com.arsdigita.portal.Portlet;
import java.util.Date;

/**
 * TimestampCachingPortletRenderer
 *
 * @author <a href="mailto:rhs@mit.edu">rhs@mit.edu</a>
 * @version $Revision: #4 $ $Date: 2004/04/07 $
 **/

public abstract class TimestampCachingPortletRenderer
    extends AbstractPortletRenderer {


    private Portlet m_portlet;

    public TimestampCachingPortletRenderer(Portlet portlet) {
        m_portlet = portlet;
    }

    public boolean isDirty() {
        Date cached = getDateCached();
        Date timestamp = getTimestamp();

        if (cached == null || timestamp == null) {
            return true;
        } else {
            return cached.getTime() < timestamp.getTime() ||
                cached.getTime() < m_portlet.getTimestamp().getTime();
        }
    }

    public Object getCacheKey() {
        return m_portlet.getID();
    }

    public abstract Date getTimestamp();

}
