/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.packaging;

import com.arsdigita.util.*;
import com.arsdigita.util.parameter.*;

import java.io.*;
import java.util.*;

/**
 * ParameterMap
 *
 * @author Rafael H. Schloming &lt;rhs@mit.edu&gt;
 * @version $Revision: #3 $ $Date: 2004/04/07 $
 **/

class ParameterMap {

    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/packaging/ParameterMap.java#3 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private List m_contexts = new ArrayList();
    private List m_parameters = new ArrayList();
    private Map m_containers = new HashMap();
    private Map m_parametersByName = new HashMap();

    public void addContext(ParameterContext context) {
        m_contexts.add(context);
        Parameter[] params = context.getParameters();
        for (int i = 0; i < params.length; i++) {
            m_parameters.add(params[i]);
            m_containers.put(params[i], context);
            m_parametersByName.put(params[i].getName(), params[i]);
        }
    }

    public void addContexts(Collection contexts) {
        for (Iterator it = contexts.iterator(); it.hasNext(); ) {
            addContext((ParameterContext) it.next());
        }
    }

    public List getContexts() {
        return m_contexts;
    }

    public List getParameters() {
        return m_parameters;
    }

    public Parameter getParameter(String name) {
        return (Parameter) m_parametersByName.get(name);
    }

    public ParameterContext getContainer(Parameter param) {
        return (ParameterContext) m_containers.get(param);
    }

    public Object get(Parameter param) {
        return getContainer(param).get(param);
    }

    public void set(Parameter param, Object obj) {
        getContainer(param).set(param, obj);
    }

    public void validate(ErrorList errs) {
        for (Iterator it = getContexts().iterator(); it.hasNext(); ) {
            ParameterContext ctx = (ParameterContext) it.next();
            ctx.validate(errs);
        }
    }

    public boolean validate(PrintStream out) {
        ErrorList errs = new ErrorList();
        validate(errs);
        if (errs.isEmpty()) {
            return true;
        } else {
            out.println(" *** Error ***");
            errs.report(new OutputStreamWriter(out));
            return false;
        }
    }

    public void load(ParameterReader reader, ErrorList errs) {
        for (Iterator it = getContexts().iterator(); it.hasNext(); ) {
            ParameterContext ctx = (ParameterContext) it.next();
            ctx.load(reader, errs);
        }
    }

    public boolean load(ParameterReader reader, PrintStream out) {
        ErrorList errs = new ErrorList();
        load(reader, errs);
        if (errs.isEmpty()) {
            return true;
        } else {
            out.println(" *** Error ***");
            errs.report(new OutputStreamWriter(out));
            return false;
        }
    }

}
