/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.metadata;

import com.arsdigita.persistence.SessionManager;
import com.redhat.persistence.metadata.Column;
import com.redhat.persistence.metadata.ForeignKey;
import com.redhat.persistence.metadata.ObjectType;
import com.redhat.persistence.metadata.Property;
import com.redhat.persistence.metadata.Table;
import com.redhat.persistence.metadata.UniqueKey;

/**
 * DynamicElement
 *
 * @author Rafael H. Schloming &lt;rhs@mit.edu&gt;
 * @version $Revision: #9 $ $Date: 2004/04/07 $
 **/

abstract class DynamicElement {

    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/metadata/DynamicElement.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * This takes an ObjectType name and model, and generates a unique
     * table name that can be used to store the object type.
     *
     * @param type The object type.
     * @return a unique table name that is used to store instance data
     *         for the object type
     */
    static String generateTableName(ObjectType type) {
	return type.getName();
    }

    /**
     * This takes a table name and a Property to generate a unique
     * column name.
     *
     * @param table The table containing the column.
     * @param name The proposed name of the column.
     * @return a unique column name that will be used to store this property
     */
    static String generateColumnName(Table table, String name) {
	return name;
    }


    /**
     * Determines a unique name for a mapping table for a particular
     * role reference and object type.
     *
     * @param prop The property being stored in the table.
     * @return a unique table name
     */
    static String generateTableName(Property prop) {
	return generateTableName(prop.getContainer()) + "_" + prop.getName();
    }

    static ForeignKey fk(Table table, String prefix, UniqueKey uk) {
	Column[] cols = new Column[uk.getColumns().length];
	for (int i = 0; i < cols.length; i++) {
	    Column col = uk.getColumns()[i];
	    String name;
	    if (prefix == null) {
		name = col.getName();
	    } else {
		name = prefix + "_" + col.getName();
	    }
	    String columnName = generateColumnName(table, name);
	    cols[i] = new Column(columnName, col.getType(), col.getSize(),
				 col.getScale(), true);
	    table.addColumn(cols[i]);
	}
	return new ForeignKey(table, null, cols, uk);
    }

    static ObjectType type
	(com.arsdigita.persistence.metadata.CompoundType type) {
	if (type == null) { return null; }
	return SessionManager.getMetadataRoot().getRoot().getObjectType
            (type.getQualifiedName());
    }

    static com.arsdigita.persistence.metadata.ObjectType type
	(ObjectType type) {
	if (type == null) { return null; }
	return SessionManager.getMetadataRoot().getObjectType
	    (type.getQualifiedName());
    }

    static Property property
	(com.arsdigita.persistence.metadata.Property prop) {
	if (prop == null) { return null; }
	return type(prop.getContainer()).getProperty(prop.getName());
    }

    static com.arsdigita.persistence.metadata.Property property
	(Property prop) {
	if (prop == null) { return null; }
	return type(prop.getContainer()).getProperty(prop.getName());
    }

}
