/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.logging.examples;

import com.arsdigita.logging.Log;
import org.apache.log4j.Logger;

/**
 * <p>
 * This is a helper class to the example class LogExampleThread
 * </p>
 *
 * @version $Revision: #9 $ $Date: 2004/04/07 $
 */
public class LogExampleThread extends Thread {
    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/logging/examples/LogExampleThread.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    // get the category named the same as this class
    private static final Logger cat = Logger.getLogger(LogExampleThread.class);

    public void run() {
        Log.secure(new Runnable() {
                public void run() {
                    try {
                        sleep((new Double(Math.random() * 100.0)).intValue());
                    } catch (InterruptedException e) {
                        // do nothing
                        return;
                    }

                    // do everything that needs to be logged securely here
                    if(Log.isSecure())
                        cat.info(
                                 "We are running securely in thread " +
                                 Thread.currentThread().getName() +
                                 ". There are " +
                                 Thread.currentThread().activeCount() +
                                 " threads currently running."
                                 );
                    else
                        cat.info(
                                 "We are not running securely in thread " +
                                 Thread.currentThread().getName() +
                                 ". There are " +
                                 Thread.currentThread().activeCount() +
                                 " threads currently running."
                                 );
                }
            });
    }
}
