/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.logging;


import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;


public class ErrorReportAppender extends FileAppender {
    
    private String m_directory;

    public ErrorReportAppender(String directory) {
        m_directory = directory;

        setLayout(new Layout() {
                public void activateOptions() {}
                public boolean ignoresThrowable() { return true; }
                
                public String format(LoggingEvent event) {
                    return ((ErrorReport)event.getMessage()).getReport();
                }
            });
        setName("ErrorReportAppender");
    }

    public void append(LoggingEvent event) {
        if (event.getMessage() instanceof ErrorReport) {
            ErrorReport report = (ErrorReport)event.getMessage();

            setFile(m_directory + "/" + report.getGuruMeditationCode() + ".txt");
            setAppend(false);
            setBufferedIO(false);
            activateOptions();

            super.append(event);
        }
    }

}
