/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.loader;

import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.ParameterRecord;
import com.arsdigita.util.parameter.StringParameter;

/**
 * MimeTypeRow
 *
 * @author Rafael H. Schloming &lt;rhs@mit.edu&gt;
 * @version $Revision: #4 $ $Date: 2004/04/07 $
 **/

class MimeTypeRow extends ParameterRecord {

    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/loader/MimeTypeRow.java#4 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private StringParameter m_type = new StringParameter
        ("waf.mime.type", Parameter.REQUIRED, null);

    private StringParameter m_label = new StringParameter
        ("waf.mime.label", Parameter.REQUIRED, null);

    private StringParameter m_extensions = new StringParameter
        ("waf.mime.extensions", Parameter.REQUIRED, null);

    private StringParameter m_objectType = new StringParameter
        ("waf.mime.object_type", Parameter.REQUIRED, null);

    private StringParameter m_sizerOrINSO = new StringParameter
        ("waf.mime.sizer_or_inso", Parameter.OPTIONAL, null);

    public MimeTypeRow() {
        super("mime-type-row");
        register(m_type);
        register(m_label);
        register(m_extensions);
        register(m_objectType);
        register(m_sizerOrINSO);
    }

    public String getType() {
        return (String) get(m_type);
    }

    public String getLabel() {
        return (String) get(m_label);
    }

    public String getExtensions() {
        return (String) get(m_extensions);
    }

    /**
     * Get default Extension (first one in list)
     **/

    public String getDefaultExtension() {
        String exts = getExtensions();
        int index = exts.indexOf(',', 0);
        if (index < 0) {
            return exts;
        } else {
            return exts.substring(0, index);
        }
    }

    private String typeName() {
        return (String) get(m_objectType);
    }

    public String getObjectType() {
        return "com.arsdigita.cms." + typeName();
    }

    public String getJavaClass() {
        return "com.arsdigita.mimetypes." + typeName();
    }

    public String getSizerOrINSO() {
        return (String) get(m_sizerOrINSO);
    }

}
