/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.kernel.ui;

import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.bebop.PageState;

/**
 * A {@link SingleSelectionModel} which loads an item from the
 * database. The isSelected() method will return true if it
 * was possible to load the item.
 */
public interface DomainObjectSelectionModel extends SingleSelectionModel {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/ui/DomainObjectSelectionModel.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Return the item which was selected and loaded from the database,
     * using the values supplied in PageState.
     *
     * @param state The page state
     * @return The item domain object, or null if no item is
     *         selected.
     *
     */
    DomainObject getSelectedObject(PageState state);

    /**
     * Select the given domain object. Should extract the selected
     * key from the object in some manner, and call setSelectedKey
     * to change the key.
     *
     * @param state The page state
     * @param object The domain object to set
     */
    void setSelectedObject(PageState state, DomainObject object);

}
