/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.kernel;

import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;

import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;

// identity class
import java.math.BigDecimal;

/**
 * Represents a collection of ACSObject domain objects.
 *
 * @author Oumi Mehrotra 
 * @version 1.0
 **/
public class ACSObjectCollection extends DomainCollection {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/ACSObjectCollection.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Constructor.
     *
     * @see com.arsdigita.domain.DomainCollection#DomainCollection(DataCollection)
     **/
    public ACSObjectCollection(DataCollection dataCollection) {
        super(dataCollection);
    }

    /**
     * Gets the value of the ID property.
     *
     * @return the value of the ID property.
     */
    public BigDecimal getID() {
        return (BigDecimal) m_dataCollection.get("id");
    }

    /**
     * 
     * Gets the denormalized display name of this object.
     *
     * @return the denormalized display name of this object.
     *
     * @see ACSObject#getDisplayName()
     */
    public String getDisplayName() {
        return (String) m_dataCollection.get("displayName");
    }

    /**
     * Gets the value of the objectType property, which is the fully
     * qualified name of the data object type that this domain object
     * had when it was first created.
     * @return the fully qualified name of this object
     */
    public String getSpecificObjectType() {
        return (String) m_dataCollection.get("objectType");
    }

    /**
     * Returns a <code>DomainObject</code> for the current position in
     * the collection.
     *
     * @see com.arsdigita.domain.DomainObject
     * @see com.arsdigita.persistence.DataCollection#getDataObject()
     **/
    public DomainObject getDomainObject() {
        DataObject data = m_dataCollection.getDataObject();
        return DomainObjectFactory.newInstance(data);
    }

    /**
     * Wrapper to <code>getDomainObject()</code> that casts the returned
     * <code>DomainObject</code> as an <code>ACSObject</code>.
     *
     * @return an <code>ACSObject</code> for the current position in the
     * collection.
     *
     * @see #getDomainObject()
     * @see Party
     * @see com.arsdigita.domain.DomainObject
     **/
    public ACSObject getACSObject() {
        return (ACSObject) getDomainObject();
    }

}
