/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.globalization;
import java.text.DateFormat;

/**
 * 
 * Standard, final constants used by the globalization APIs. This
 * interface is designed to be extended on a package-by-package basis
 * to include package-specific constants. A typical package specific
 * constant would be the resource bundle name for a given package. By
 * extending the Globalized interface and defining a final static
 * BUNDLE_NAME constant, classes implementing the Globalized interface
 * could call {@link GlobalizedMessage} and pass in the BUNDLE_NAME
 * constant i.e.,
 *
 * <p>
 * <pre>
 *  new GlobalizedMessage("forums.newpost.proofread",
 *                        BUNDLE_NAME)
 * </pre>
 * </p>
 *
 * @version $Revision: #8 $ $Date: 2004/04/07 $
 */
public interface Globalized {
    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/globalization/Globalized.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * The default format for displaying dates.
     */
    public final static int DATE_DISPLAY_FORMAT = java.text.DateFormat.MEDIUM;

    /**
     * The default format for displaying time.
     */
    public final static int TIME_DISPLAY_FORMAT = java.text.DateFormat.SHORT;

    /**
     * Override the value of this string for your particular package.
     */
    public final static String BUNDLE_NAME = "com.arsdigita.globalization";

}
