/*
 * Copyright (C) 2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder.util;

import com.arsdigita.bebop.page.PageTransformer;
import com.arsdigita.runtime.AbstractConfig;
import com.arsdigita.templating.PresentationManager;
import com.arsdigita.ui.SimplePage;
import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.StringParameter;
import com.arsdigita.web.URL;
import org.apache.log4j.Logger;


/**
 * @author Justin Ross
 * @see com.arsdigita.bebop.Bebop
 */
public final class FormBuilderConfig extends AbstractConfig {
    public static final String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/formbuilder/util/FormBuilderConfig.java#3 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger(FormBuilderConfig.class);

    private final Parameter m_actionsHelp;
    private final Parameter m_controlsHelp;

    public FormBuilderConfig() {
        m_actionsHelp = new StringParameter
            ("waf.formbulider.actions_help_url", Parameter.REQUIRED, "");

        m_controlsHelp = new StringParameter
            ("waf.formbulider.controls_help_url", Parameter.REQUIRED, "");


        register(m_actionsHelp);
        register(m_controlsHelp);

        loadInfo();
    }

    /**
     *  This returns the string that can be used to create the URL to
     *  point to the help page.  If it starts with "/" then it is
     *  assumed to be located on this server.  If it starts with
     *  anything else, it is assumed to be a link to a foreign site.
     *   This can be null is no help link should appear
     */
    public String getActionsHelpLink() {
        return (String) get(m_actionsHelp);
    }

    /**
     *  This returns the string that can be used to create the URL to
     *  point to the help page.  
     *   This can be null is no help link should appear
     */
    public String getControlsHelpLink() {
        return (String)get(m_controlsHelp);
    }
}
