/*
 * Copyright (C) 2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder.ui.editors;


import com.arsdigita.formbuilder.util.GlobalizationUtil ; 



import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.globalization.GlobalizedMessage;

import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.FormProcessListener;

import com.arsdigita.bebop.form.TextField;

import com.arsdigita.bebop.parameters.StringParameter;

import com.arsdigita.domain.DataObjectNotFoundException;

import com.arsdigita.formbuilder.PersistentText;


import java.math.BigDecimal;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.formbuilder.PersistentText;
import com.arsdigita.formbuilder.PersistentFormSection;
import com.arsdigita.formbuilder.ui.PropertiesForm;
import com.arsdigita.bebop.parameters.StringInRangeValidationListener;
import com.arsdigita.bebop.parameters.NotEmptyValidationListener;
import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.form.Widget;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.util.UncheckedWrapperException;
import org.apache.log4j.Logger;



public class TextForm extends PropertiesForm 
    implements FormInitListener, FormProcessListener {

    private static final Logger s_log =
        Logger.getLogger(TextForm.class);

    private Widget m_text;
    private SingleSelectionModel m_action;
    private SingleSelectionModel m_form;

    public TextForm(String name,
                    SingleSelectionModel form,
                    SingleSelectionModel action) {
        super(name);
        m_action = action;
        m_form = form;
        addProcessListener(this);
        addInitListener(this);
    }


    protected void addWidgets(FormSection section) {
        super.addWidgets(section);

        m_text = getTextWidget(new StringParameter("text"));
        m_text.addValidationListener(new NotEmptyValidationListener());
        section.add(new Label(getTextTitle()), ColumnPanel.RIGHT);
        section.add(m_text);
    }

    /**
     *  this returns the widget that is used in the "addWidgets" method
     *  can provides subclasses with the ability to use any size desired
     */
    protected Widget getTextWidget(StringParameter parameter) {
        return new TextArea(parameter);
    }

    /**
     *  Subclasses can override this so that it will give the correct
     *  name to the text.
     */
    protected GlobalizedMessage getTextTitle() {
        return GlobalizationUtil.globalize
            ("formbuilder.ui.editors.text_form_title");
    }

    public void init(FormSectionEvent e)
        throws FormProcessException {
        
        PageState state = e.getPageState();

        BigDecimal action = (BigDecimal)m_action.getSelectedKey(state);
        if (action != null) {
            try {
                PersistentText text = getPersistentText(action);
                m_text.setValue(state, text.getText());
            } catch (DataObjectNotFoundException ex) {
                s_log.error("Unable to find Persistent Text for id " + 
                            action, ex);
            }
        }
    }


    public void process(FormSectionEvent e)
        throws FormProcessException {
        
        PageState state = e.getPageState();
        
        if (isCancelled(state)) {
            return;
        }
        
        PersistentText text = getPersistentText(state);

        String textString = (String)m_text.getValue(state);
        text.setText(textString);
        text.save();
        
        BigDecimal action = (BigDecimal)m_action.getSelectedKey(state);
        if (action == null) {
            addToForm(e, text);
        }
    }

    protected void addToForm(FormSectionEvent e,
                             PersistentText widget)
        throws FormProcessException {

        BigDecimal form_id = (BigDecimal)m_form.getSelectedKey(e.getPageState());

        PersistentFormSection form = null;
        try {
            form = new PersistentFormSection(form_id);
        } catch (DataObjectNotFoundException ex) {
            throw new FormProcessException("cannot find form", ex);
        }

        form.addComponent(widget);
        form.save();
    }

    protected PersistentText getPersistentText() {
        return new PersistentText();
    }

    protected PersistentText getPersistentText(BigDecimal id)
        throws DataObjectNotFoundException {
        return new PersistentText(id);
    }

    protected PersistentText getPersistentText(PageState state) {
        BigDecimal action = (BigDecimal)m_action.getSelectedKey(state);
        if (action != null) {
            try {
                return getPersistentText(action);
            } catch (DataObjectNotFoundException ex) {                
                s_log.error("Unable to find Persistent Text for id " + 
                            action, ex);
                throw new UncheckedWrapperException
                    ("cannot find Persistent Text for id " + action, ex);
            }
        } else {
            return getPersistentText();
        }
    }
}
