/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder.ui.editors;


import com.arsdigita.formbuilder.util.GlobalizationUtil ; 


import com.arsdigita.formbuilder.parameters.TextValidationListener;

import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;

import com.arsdigita.bebop.event.FormSectionEvent;

import com.arsdigita.bebop.form.TextField;

import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.bebop.parameters.StringParameter;

import com.arsdigita.domain.DataObjectNotFoundException;

import com.arsdigita.formbuilder.PersistentTextField;


import java.math.BigDecimal;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.formbuilder.PersistentWidget;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.NumberInRangeValidationListener;
import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.formbuilder.parameters.PersistentParameterListener;
import java.util.Iterator;


public class TextFieldForm extends WidgetLabelForm {
    private TextField m_width;
    private TextField m_length;
    private TextField m_value;
    private SingleSelect m_datatype;

    private SingleSelectionModel m_control;

    public TextFieldForm(String name,
                         SingleSelectionModel form,
                         SingleSelectionModel control) {
        super(name, form, control);
        m_control = control;
    }

    protected void addWidgets(FormSection section) {
        super.addWidgets(section);

        m_length = new TextField(new IntegerParameter("length"));
        m_length.setSize(5);
        m_length.addValidationListener(new NotNullValidationListener());
        m_length.addValidationListener(new NumberInRangeValidationListener(1, 70));
        section.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.editors.max_length")), ColumnPanel.RIGHT);
        section.add(m_length);

        m_width = new TextField(new IntegerParameter("width"));
        m_width.setSize(5);
        m_width.addValidationListener(new NotNullValidationListener());
        section.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.editors.width")), ColumnPanel.RIGHT);
        section.add(m_width);

        m_value = new TextField(new StringParameter("value"));
        m_value.setSize(50);
        section.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.editors.default_value")), ColumnPanel.RIGHT);
        section.add(m_value);

        m_datatype = new SingleSelect("datatype");
        section.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.editors.data_type")), ColumnPanel.RIGHT);
        section.add(m_datatype);

        Integer types[] = TextValidationListener.getValidationTypes();
        for (int i = 0 ; i < types.length ; i++) {
            m_datatype.addOption(new Option(types[i].toString(),
                                            TextValidationListener.getValidationTypeName(types[i])));
        }
    }

    protected PersistentWidget getWidget() {
        return new PersistentTextField();
    }

    protected PersistentWidget getWidget(BigDecimal id)
        throws DataObjectNotFoundException {

        return new PersistentTextField(id);
    }

    protected void initWidgets(FormSectionEvent e,
                               PersistentWidget w)
        throws FormProcessException {
        super.initWidgets(e, w);

        PersistentTextField widget = (PersistentTextField)w;

        PageState state = e.getPageState();

        if (widget == null) {
            m_width.setValue(state, "");
            m_length.setValue(state, "");
            m_value.setValue(state, "");
        } else {
            m_width.setValue(state, new Integer(widget.getSize()));
            m_length.setValue(state, new Integer(widget.getMaxLength()));
            m_value.setValue(state, widget.getDefaultValue());
        }

        TextValidationListener tfl = null;
        if (widget != null) {
            Iterator iter = widget.getValidationListeners().iterator();
            while (iter.hasNext()) {
                PersistentParameterListener l = (PersistentParameterListener)iter.next();
                if (l instanceof TextValidationListener) {
                    tfl = (TextValidationListener)l;
                    break;
                }
            }
        }

        if (tfl != null) {
            FormData d = e.getFormData();
            d.getParameter("datatype").setValue(tfl.getValidationType().toString());
        }
    }

    protected void processWidgets(FormSectionEvent e,
                                  PersistentWidget w)
        throws FormProcessException {
        super.processWidgets(e, w);

        PersistentTextField widget = (PersistentTextField)w;

        FormData data = e.getFormData();
        PageState state = e.getPageState();

        Integer length = (Integer)data.get("length");
        Integer width = (Integer)data.get("width");
        String value = (String)data.get("value");

        widget.setMaxLength(length.intValue());
        widget.setSize(width.intValue());
        widget.setDefaultValue(value);

        String validate = (String)m_datatype.getValue(state);
        
        TextValidationListener tfl = new TextValidationListener(new Integer(validate));
        widget.addValidationListener(tfl);
    }
}
