/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder.ui.editors;


import com.arsdigita.formbuilder.util.GlobalizationUtil ; 


import com.arsdigita.formbuilder.actions.SimpleEmailListener;

import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;

import com.arsdigita.bebop.event.FormSectionEvent;

import com.arsdigita.bebop.form.TextField;

import com.arsdigita.bebop.parameters.StringParameter;

import com.arsdigita.domain.DataObjectNotFoundException;



import java.math.BigDecimal;

import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.formbuilder.PersistentProcessListener;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.EmailParameter;
import com.arsdigita.bebop.parameters.StringInRangeValidationListener;
import com.arsdigita.bebop.ColumnPanel;


public class SimpleEmailForm extends ProcessListenerForm {
    private TextField m_to;
    private TextField m_subject;

    public SimpleEmailForm(String name,
                           SingleSelectionModel form,
                           SingleSelectionModel action) {
        super(name, form, action);
    }

    protected void addWidgets(FormSection section) {
        super.addWidgets(section);

        m_to = new TextField(new EmailParameter("to"));
        m_to.setSize(50);
        m_to.addValidationListener(new NotNullValidationListener());
        //m_to.addValidationListener(new StringInRangeValidationListener(1, 120));
        section.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.editors.to")), ColumnPanel.RIGHT);
        section.add(m_to);

        m_subject = new TextField(new StringParameter("subject"));
        m_subject.setSize(50);
        m_subject.addValidationListener(new NotNullValidationListener());
        m_subject.addValidationListener(new StringInRangeValidationListener(1, 120));
        section.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.editors.subject")), ColumnPanel.RIGHT);
        section.add(m_subject);
    }

    protected PersistentProcessListener getProcessListener() {
        return new SimpleEmailListener();
    }

    protected PersistentProcessListener getProcessListener(BigDecimal id)
        throws DataObjectNotFoundException {

        return new SimpleEmailListener(id);
    }

    protected void initWidgets(FormSectionEvent e,
                               PersistentProcessListener listener)
        throws FormProcessException {
        super.initWidgets(e, listener);

        SimpleEmailListener l = (SimpleEmailListener)listener;

        PageState state = e.getPageState();

        if (l == null) {
            m_to.setValue(state, "");
            m_subject.setValue(state, "");
        } else {
            m_to.setValue(state, l.getTo());
            m_subject.setValue(state, l.getSubject());
        }
    }

    protected void processWidgets(FormSectionEvent e,
                                  PersistentProcessListener listener)
        throws FormProcessException {
        super.processWidgets(e, listener);

        SimpleEmailListener l = (SimpleEmailListener)listener;

        FormData data = e.getFormData();

        String to = data.get("to").toString();
        String subject = (String)data.get("subject");

        l.setTo(to);
        l.setSubject(subject);
    }
}
