/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder.ui;

import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.FormProcessException;



public class PropertiesEditor extends SimpleContainer {

    PropertiesForm m_form;
    String m_app;

    public PropertiesEditor(PropertiesForm form) {
        m_form = form;

        add(m_form);
    }

    public void setApplication(String app) {
        m_app = app;
        m_form.setApplication(app);
    }

    public String getApplication() {
        return m_app;
    }

    public PropertiesForm getPropertiesForm() {
        return m_form;
    }

    public boolean isComplete(PageState state) {
        return m_form.isComplete(state);
    }

    public boolean isCancelled(PageState state) {
        return m_form.isCancelled(state);
    }

    public void addProcessListener(FormProcessListener l) {
        m_form.addProcessListener(new PropertiesFormProcessListener(l));
    }

    public void addSubmissionListener(FormSubmissionListener l) {
        m_form.addSubmissionListener(new PropertiesFormSubmissionListener(l));
    }

    protected class PropertiesFormProcessListener implements FormProcessListener {
        FormProcessListener m_l;

        public PropertiesFormProcessListener(FormProcessListener l) {
            m_l = l;
        }

        public void process(FormSectionEvent e)
            throws FormProcessException {

            m_l.process(new FormSectionEvent(PropertiesEditor.this,
                                             e.getPageState(),
                                             e.getFormData()));
        }
    }

    protected class PropertiesFormSubmissionListener implements FormSubmissionListener {
        FormSubmissionListener m_l;

        public PropertiesFormSubmissionListener(FormSubmissionListener l) {
            m_l = l;
        }

        public void submitted(FormSectionEvent e)
            throws FormProcessException {

            m_l.submitted(new FormSectionEvent(PropertiesEditor.this,
                                               e.getPageState(),
                                               e.getFormData()));
        }
    }
}
