/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder;


// Objects of this class are ACSObjects that is identified by a unique number
import java.math.BigDecimal;

// This factory creates Hiddens
import com.arsdigita.bebop.form.Hidden;

// Every PersistentComponentFactory can create a Bebop Component
import com.arsdigita.bebop.Component;

// Id class used by internal constructor
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.metadata.ObjectType;

// Thrown if the underlying DataObject with given id cannot be found
import com.arsdigita.domain.DataObjectNotFoundException;

// ACS 5 uses Log4J for logging
import org.apache.log4j.Logger;


/**
 * This class is responsible for persisting Bebop Hiddens. The Hidden
 * is saved with the save() method. To resurrect the Hidden, use the constructor
 * taking the id of the saved Hidden and then invoke createComponent().
 *
 * @author Peter Marklund
 * @version $Id: //core-platform/dev/src/com/arsdigita/formbuilder/PersistentHidden.java#9 $
 *
 */
public class PersistentHidden extends PersistentWidget {

    private static final Logger s_log =
        Logger.getLogger(PersistentHidden.class.getName());

    /**
     * The fully qualified name of the underlying DataObject of this class.
     */
    public static final String BASE_DATA_OBJECT_TYPE =
        "com.arsdigita.formbuilder.Widget";

    // *** Constructors -------------

    /**
     * Constructor that creates a new Hidden domain object that
     * can be saved to the database later on. This class was only
     * included to make it possible to use this DomainObject with the
     * FormGenerator (to make the class JavaBean compliant). Use the constructor
     * taking a parameter name instead if possible.
     */
    public PersistentHidden() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    /**
     * Constructor that creates a new Hidden domain object that
     * can be saved to the database later on.
     */
    public PersistentHidden(String typeName) {
        super(typeName);
    }

    public PersistentHidden(ObjectType type) {
        super(type);
    }

    public PersistentHidden(DataObject obj) {
        super(obj);
    }

    /**
     * Constructor that retrieves an existing Hidden domain object
     * from the database.
     *
     * @param id The object id of the Hidden domain object to retrieve
     */
    public PersistentHidden(BigDecimal id)
        throws DataObjectNotFoundException {

        this(new OID(BASE_DATA_OBJECT_TYPE, id));
    }

    /**
     * Extending classes can use this constructor to set the sub class
     * id and object type.
     */
    public PersistentHidden(OID oID)
        throws DataObjectNotFoundException {

        super(oID);
    }

    public static PersistentHidden create(String parameterName) {
        PersistentHidden c = new PersistentHidden();
        c.setup(parameterName);
        return c;
    }

    /**
     * Create the Hidden whose persistence is managed
     * by this domain object.
     */
    public Component createComponent() {

        Hidden hidden = new Hidden(getParameterName());

        copyValuesToWidget(hidden);

        return hidden;
    }
}
