/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder;




/**
 * Implemented by classes that contain persistent Bebop components. The
 * components are added via their corresponding PersistentComponentFactory that
 * knows how to create the component. The relationship between the container
 * and the components is an aggregate association (in UML terminology) with
 * multiplicity 0..N on both ends of the association.
 *
 * @author Peter Marklund
 * @version $Id: //core-platform/dev/src/com/arsdigita/formbuilder/PersistentContainer.java#8 $
 *
 */
public interface PersistentContainer {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/formbuilder/PersistentContainer.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Add a component last in the list of components in
     * this container.
     */
    public void addComponent(PersistentComponentFactory componentFactory);


    /**
     * Add a component to the Container at the given position.
     *
     * @param position The position to add the component at. Positions start
     *                 with 1
     */
    public void addComponent(PersistentComponentFactory componentFactory,
                             int position);

    /**
     * Remove a component from the Container
     */
    public void removeComponent(PersistentComponentFactory componentFactory);

    /**
     * Move component to new position.
     *
     * @param toPosition The position to move the component to. Positions start with 1.
     */
    public void moveComponent(PersistentComponentFactory componentFactory,
                              int toPosition);

    /**
     * Delete all component associations from this container
     */
    public void clearComponents();
}
