/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.domain.installer;


import com.arsdigita.domain.xml.TraversalHandler;
import com.arsdigita.initializer.Configuration;
import com.arsdigita.initializer.InitializationException;
import com.arsdigita.xml.XML;

import org.apache.log4j.Logger;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

public class DomainObjectTraversalInitializer
    implements com.arsdigita.initializer.Initializer {

    public static final String ADAPTERS = "adapters";

    private static final Logger s_log =
        Logger.getLogger(DomainObjectTraversalInitializer.class);

    private Configuration m_config = new Configuration();

    public DomainObjectTraversalInitializer()
        throws InitializationException {
        m_config.initParameter
            (ADAPTERS,
             "The path to an XML file containing adapter specifications",
             List.class);
    }

    public Configuration getConfiguration() {
        return m_config;
    }

    public void startup() throws InitializationException {
        List adapters = (List) m_config.getParameter(ADAPTERS);

        if (adapters != null) {
            Iterator i = adapters.iterator();
            while (i.hasNext()) {
                String path = (String) i.next();
                XML.parseResource(path, new TraversalHandler());
            }
        } else {
            s_log.warn("No file specified for loading adapters");
        }
    }

    public void shutdown() throws InitializationException {
        // nada
    }

}
