/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.domain;

/**
 * The GlobalObserver interface can be used in conjunction with the
 * GlobalObserverManager to register an observer that will observe every
 * single observable domain object. This should be used with extreme caution
 * since global observers can be called for every single operation that
 * happens on any domain object. If one of the global observers is slow or
 * error prone this could cause the system to become slow and/or extremely non
 * robust.
 *
 * @author <a href="mailto:rhs@mit.edu">rhs@mit.edu</a>
 * @version $Revision: #6 $ $Date: 2004/04/07 $
 **/

public interface GlobalObserver extends DomainObjectObserver {

    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/domain/GlobalObserver.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";


    /**
     * This method should return a value indicating whether or not this
     * GlobalObserver wishes to observe the given domain object.
     *
     * @param dobj The domain object that is a candidate for observation.
     **/

    boolean shouldObserve(DomainObject dobj);

}
