/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.domain;

import com.arsdigita.persistence.metadata.Property;

/**
 * An implementation of DomainObjectTraversal that generates a single
 * string containing all the data from the object's traversed
 * properties.
 *
 * @version $Id: //core-platform/dev/src/com/arsdigita/domain/DomainObjectTextRenderer.java#5 $
 */
public class DomainObjectTextRenderer extends DomainObjectTraversal {

    private StringBuffer m_text;

    /**
     */
    public DomainObjectTextRenderer() {
        m_text = new StringBuffer("");
    }

    public String getText() {
        return m_text.toString();
    }

    protected void beginObject(DomainObject obj,
                               String path) {
    }

    protected void endObject(DomainObject obj,
                             String path) {
    }

    protected void revisitObject(DomainObject obj,
                                 String path) {
    }

    protected void handleAttribute(DomainObject obj,
                                   String path,
                                   Property property) {
        Object value = obj.get(property.getName());

        if (value != null) {
            m_text.append(" " + value);
        }
    }

    protected void beginRole(DomainObject obj,
                             String path,
                             Property property) {
    }

    protected void endRole(DomainObject obj,
                           String path,
                           Property property) {
    }


    protected void beginAssociation(DomainObject obj,
                                    String path,
                                    Property property) {
    }

    protected void endAssociation(DomainObject obj,
                                  String path,
                                  Property property) {
    }

}
