/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.dmi;

import com.arsdigita.xmlinterp.XMLWalker;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 *
 * @author Bryan Che (bche@redhat.com)
 * @version $Revision: #11 $ $Date: 2004/04/07 $
 * @since CCM Core 5.2
 *
 */

public class Application {

    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/dmi/Application.java#11 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log =
        Logger.getLogger(Application.class);

    private HashMap m_versionMap = new HashMap();
    private String m_sCurrentVersionName = null;
    private String m_sDatabase = null;
    private String m_sDescription = null;
    private String m_sInstallFile = null;
    private String m_sName = null;

    public Application(File prodFile, String database) throws ParserConfigurationException, SAXException, IOException {
        m_sDatabase = database;

        //read in the XML file and store the information

        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        ProductXMLInterpreter pxi = new ProductXMLInterpreter();
        XMLWalker xmlwalker = new XMLWalker();

        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(prodFile);
        xmlwalker.walk(doc, pxi);

        m_sName = pxi.getProductName();
        m_sDescription = pxi.getProductDescription();
        m_sCurrentVersionName = pxi.getCurrentVersion();
        m_sInstallFile = pxi.getInstallFile(m_sDatabase);

        //store version info
        ApplicationVersion[] avArray = pxi.getVersions(m_sDatabase);

        //XXX
        if ( avArray == null ) {
            s_log.warn ("No version history was found");
            return;
        } else {
            s_log.warn ("avArray: " + avArray);
            for (int i=0; i < avArray.length; i++) {
                ApplicationVersion av = avArray[i];

                m_versionMap.put(av.getName(), av);
            }
        }
    }

    public String getDatabase() {
        return m_sDatabase;
    }

    public String getName() {
        return m_sName;
    }

    public String getDescription() {
        return m_sDescription;
    }

    public String getCurrentVersion() {
        return m_sCurrentVersionName;
    }

    public String getDataModelInstallFileName() {
        return m_sInstallFile;
    }

    public ApplicationVersion[] getUpgradePath(String sVersion) {
        //find the path from the current version to the version from which we're upgrading

        Vector v = new Vector();

        ApplicationVersion av = (ApplicationVersion)m_versionMap.get(m_sCurrentVersionName);

        while ( av.getName().compareTo(sVersion) != 0 ) {
            v.insertElementAt(av, 0);
            av = (ApplicationVersion)m_versionMap.get(av.getPreviousVersionName());
        }

        ApplicationVersion avArray[] = new ApplicationVersion[0];
        return (ApplicationVersion[])v.toArray(avArray);
    }

}
