/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.dispatcher;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

/**
 * A servlet that redirects. It takes parameter a servlet parameter "target"
 * that is used for the destination of the redirect.
 **/

public class RedirectorServlet extends HttpServlet {

    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/dispatcher/RedirectorServlet.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger(
        RedirectorServlet.class);

    public static final String PARAM_NAME = "target";

    public String m_target = null;

    public void init() throws ServletException {
        ServletConfig conf = getServletConfig();
        m_target = conf.getInitParameter(PARAM_NAME);
        if (s_log.isDebugEnabled()) {
            s_log.debug("setting target to: " + m_target);
        }
    }

    public void service(HttpServletRequest req, HttpServletResponse resp)
        throws ServletException, IOException {

        if (s_log.isDebugEnabled()) {
            s_log.debug("redirecting: " + req.getRequestURI());
        }

        DispatcherHelper.sendExternalRedirect(resp, m_target);
    }
    
    public void destroy() { }
}
