/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.dispatcher;

interface DispatcherConstants {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/dispatcher/DispatcherConstants.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Attribute name for the Throwable object saved when a JSP
     * handles an error with the errorPage directive.
     */
    final static String JSP_EXCEPTION_ATTRIBUTE =
        "javax.servlet.jsp.jspException";

    /**
     * Attribute name for the URI that caused an error
     * when the servlet container forwards to an error page.
     */
    final static String ERROR_REQUEST_ATTRIBUTE =
        "javax.servlet.error.request_uri";

    /**
     * Attribute name to indicate that the dispatcher is within
     * a request--that is, request start listeners have run but
     * request end listeners haven't yet.
     */
    final static String REENTRANCE_ATTRIBUTE =
        "com.arsdigita.dispatcher.inside_request";

    /**
     * The attribute name for an included resource URI after
     * a servlet include (nesting).
     */
    final static String INCLUDE_URI =
        "javax.servlet.include.request_uri";

    /**
     * The attribute where we store the current RequestContext
     * object.
     */
    final static String REQUEST_CONTEXT_ATTR =
        "com.arsdigita.dispatcher.RequestContext";

    /**
     * The attribute where we store the original HttpServletRequest
     * object when we need to wrap the servlet request.
     */
    final static String ORIGINAL_REQUEST_ATTR =
        "com.arsdigita.dispatcher.OriginalRequest";

    /**
     * The attribute where we store the wrapped servlet request
     * object when we need to restore the original request object
     * for a forward/include.
     */
    final static String WRAPPED_REQUEST_ATTR =
        "com.arsdigita.dispatcher.WrappedRequest";

    /**
     * The session attribute where we store an identifier for the
     * previous request that made a redirect.  This prohibits us from
     * following a redirect until after the request that generated the
     * redirect commits its transaction.
     */
    final static String REDIRECT_SEMAPHORE =
        "com.arsdigita.dispatcher.redirect_semaphore";

    /**
     * The application attribute (in ServletContext) where we store the
     * list of welcome files from web.xml.
     */
    final static String WELCOME_FILES =
        "com.arsdigita.dispatcher.welcomefiles";


    final static String DISPATCHER_PREFIX_ATTR = 
        "com.arsdigita.dispatcher.DispatcherPrefix";
}
