/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.dispatcher;

import com.arsdigita.runtime.AbstractConfig;
import com.arsdigita.templating.PresentationManager;
import com.arsdigita.util.parameter.IntegerParameter;
import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.BooleanParameter;
import com.arsdigita.util.parameter.StringParameter;
import org.apache.log4j.Logger;

/**
 * @author Randy Graebner
 */
public final class DispatcherConfig extends AbstractConfig {
    public static final String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/dispatcher/DispatcherConfig.java#5 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger(DispatcherConfig.class);

    private final Parameter m_staticURLPrefix;
    private final Parameter m_cachingActive;
    private final Parameter m_defaultExpiry;

    public DispatcherConfig() {
        m_staticURLPrefix = new StringParameter
            ("waf.dispatcher.static_url_prefix", Parameter.REQUIRED,
             "/STATICII/");

        m_cachingActive = new BooleanParameter
            ("waf.dispatcher.is_caching_active", 
             Parameter.REQUIRED, Boolean.TRUE);

        // defaults to three days 
        m_defaultExpiry = new IntegerParameter
            ("waf.dispatcher.default_expiry", Parameter.REQUIRED,
             new Integer(259200));

        register(m_staticURLPrefix);
        register(m_cachingActive);
        register(m_defaultExpiry);

        loadInfo();
    }

    /**
     *  Get the URL for static items
     */
    public String getStaticURLPrefix() {
        return (String)get(m_staticURLPrefix);
    }

    /**
     *  This returns Boolean.TRUE if the caching is active
     */
    public Boolean getCachingActive() {
        return (Boolean)get(m_cachingActive);
    }

    public boolean isCachingActive() {
        return Boolean.TRUE.equals(getCachingActive());
    }

    /**
     *  This returns the number of seconds something is cached for
     */
    public Integer getDefaultExpiryTime() {
        return (Integer)get(m_defaultExpiry);
    }
    
}
