/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.developersupport;

import java.util.HashMap;

/**
 *
 * @author Joseph A. Bank (jbank@alum.mit.edu)
 * @version 1.0
 **/
public abstract class DeveloperSupportListener {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/developersupport/DeveloperSupportListener.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * requestStart
     * Callback indicating a new request has started.
     * Request is an opaque pointer for now for linkage purposes (don't want
     * to have dependencies on the dispatcher here) and for making this
     * infrastructure more general.
     */
    public void requestStart(Object request) {
    }

    /**
     * requestAddProperty
     * Add a new property about this request.
     */
    public void requestAddProperty(Object request, String property, Object value) {
    }
    /**
     * requestEnd
     * Callback indicating the request ended
     */
    public void requestEnd(Object request) {
    }

    /**
     * logQuery
     * Callback logging a database query
     */
    public void logQuery(int connection_id,
                         String type,
                         String query,
                         HashMap bindvars,
                         long time,
                         java.sql.SQLException sqle) {
    }

    /**
     * logComment
     * Log a generic comment
     */
    public void logComment(String comment) {
    }

    /**
     * startStage
     * Callback indicating a new stage has started.
     * Stages can be used to log help mark the time
     * taken to perform various parts of requests.
     */
    public void startStage(String stagename) {
    }

    /**
     * endStage
     * Callback indicating a stage has ended.
     * Stages can be used to log help mark the time
     * taken to perform various parts of requests.
     */
    public void endStage(String stagename) {
    }
}
