/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.util;

/**
 * An interface that contains all the Bebop
 * constants that are used by Bebop components in generating the
 * output XML.
 *
 * @author Jim Parsons
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/util/BebopConstants.java#8 $
 */
public interface BebopConstants {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/util/BebopConstants.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    String BEBOP_CHECKBOXGROUP = "bebop:checkboxGroup";
    String BEBOP_CHECKBOX      = "bebop:checkbox";
    String BEBOP_DATE          = "bebop:date";
    String BEBOP_DATETIME      = "bebop:datetime";
    String BEBOP_MULTISELECT   = "bebop:multiSelect";
    String BEBOP_OPTION        = "bebop:option";
    String BEBOP_RADIOGROUP    = "bebop:radioGroup";
    String BEBOP_RADIO         = "bebop:radio";
    String BEBOP_SELECT        = "bebop:select";
    String BEBOP_TEXTAREA      = "bebop:textarea";
    String BEBOP_DHTMLEDITOR   = "bebop:dhtmleditor";
    String BEBOP_FORMWIDGET    = "bebop:formWidget";
    String BEBOP_FORMERRORS    = "bebop:formErrors";
    String BEBOP_PORTAL        = "bebop:portal";
    String BEBOP_PORTLET       = "bebop:portlet";
    String BEBOP_BOXPANEL      = "bebop:boxPanel";
    String BEBOP_CELL          = "bebop:cell";
    String BEBOP_COLUMNPANEL   = "bebop:columnPanel";
    String BEBOP_GRIDPANEL     = "bebop:gridPanel";
    String BEBOP_BORDER        = "bebop:cell";
    String BEBOP_PAD           = "bebop:pad";
    String BEBOP_PADFRAME      = "bebop:padFrame";
    String BEBOP_PANELROW      = "bebop:panelRow";
    String BEBOP_LIST          = "bebop:list";
    String BEBOP_TABLE         = "bebop:table";
    String BEBOP_TABLEBODY     = "bebop:tbody";
    String BEBOP_TABLEROW      = "bebop:trow";
    String BEBOP_SEG_PANEL     = "bebop:segmentedPanel";
    String BEBOP_SEGMENT       = "bebop:segment";
    String BEBOP_SEG_BODY      = "bebop:segmentBody";
    String BEBOP_SEG_HEADER    = "bebop:segmentHeader";

}
