/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.tree;

import com.arsdigita.bebop.Tree;
import com.arsdigita.bebop.PageState;
import com.arsdigita.util.Lockable;

/**
 *  The interface builds a
 * {@link TreeModel} for a {@link Tree}.
 *
 * @author Stanislav Freidin 
 *
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/tree/TreeModelBuilder.java#8 $ */
public interface TreeModelBuilder extends Lockable {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/tree/TreeModelBuilder.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Builds a {@link TreeModel} to be used in the current request
     *
     * @param t The {@link Tree} that will use the model
     * @param s The page state
     */
    TreeModel makeModel(Tree t, PageState s);
}
