/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.tree;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Tree;

/**
 *  The interface
 * describes how a tree node (component) can be rendered.
 *
 * @author David Lutterkort
 * @author Tri Tran
 *
 * @see TreeModel
 * @see TreeNode
 * @see Tree
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/tree/DefaultTreeCellRenderer.java#9 $ */
public class DefaultTreeCellRenderer implements TreeCellRenderer {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/tree/DefaultTreeCellRenderer.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    /**
     * Returns node component to be displayed.  The component's
     * <code>generateXML</code> or <code>print</code> is called
     * to render the node.
     *
     * @param tree the <code>Tree</code> in which this node is being displayed
     * @param state represents the state of the current request
     * @param value the object returned by the TreeModel for that node,
     *              such as pretty name
     * @param isSelected true if the node is selected
     * @param isExpanded true if the node is expanded (not collapsed)
     * @param isLeaf true if the node is a leaf node (no children)
     * @param key the object uniquely identify that node (primary key)
     * @return the component used to generate the output for the node item
     */
    public Component getComponent (Tree tree, PageState state, Object value,
                                   boolean isSelected, boolean isExpanded,
                                   boolean isLeaf, Object key) {
        Label l = new Label(value.toString());
        // Bold if selected
        if (isSelected) {
            l.setFontWeight(Label.BOLD);
            return l;
        }
        // Currently, we are not doing anything special here for
        // collapsed/expanded node, or leaf node... Also not doing anything
        // fancy with node's key.  We are leaving this to Tree.java for now
        // to set the appropriate attributes...
        return new ControlLink(l);
    }
}
