/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.table;

import java.util.ArrayList;
import java.util.Iterator;

import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.ParameterSingleSelectionModel;
import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.util.Assert;

/**
 * Describe interface <code>TableColumnModel</code> here.
 *
 * @author David Lutterkort
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/table/DefaultTableColumnModel.java#7 $
 */
public class DefaultTableColumnModel implements TableColumnModel {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/table/DefaultTableColumnModel.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private static final String SELECTED_COLUMN="col";

    private boolean m_locked;

    private ArrayList m_columns;

    private SingleSelectionModel m_selection;

    public DefaultTableColumnModel() {
        this(new Object[0]);
    }

    public DefaultTableColumnModel(SingleSelectionModel sel) {
        this(new Object[0], sel);
    }

    public DefaultTableColumnModel(Object[] headers) {
        this(headers,
             new ParameterSingleSelectionModel(new IntegerParameter(SELECTED_COLUMN)) );
    }

    public DefaultTableColumnModel(Object[] headers, SingleSelectionModel sel) {
        m_columns = new ArrayList();
        m_selection = sel;

        for (int i=0; i < headers.length; i++) {
            add(new TableColumn(i, headers[i], new Integer(i)));
        }
    }

    public void add(TableColumn column) {
        Assert.assertNotLocked(this);
        m_columns.add(column);
    }

    public void add(int columnIndex, TableColumn column) {
        Assert.assertNotLocked(this);
        m_columns.add(columnIndex, column);
    }

    public TableColumn get(int columnIndex) {
        return (TableColumn) m_columns.get(columnIndex);
    }

    public void set(int columnIndex, TableColumn v) {
        m_columns.set(columnIndex, v);
    }

    public int size() {
        return m_columns.size();
    }

    public int getIndex(Object key) {
        if ( key == null ) {
            return -1;
        }
        for (int i=0; i<size(); i++) {
            TableColumn t  = get(i);
            if ( key.equals(t.getHeaderKey()) ) {
                return i;
            }
        }
        return -1;
    }

    public Iterator columns() {
        return m_columns.iterator();
    }

    public void remove(TableColumn column) {
        Assert.assertNotLocked(this);
        m_columns.remove(column);
    }

    public final SingleSelectionModel getSelectionModel() {
        return m_selection;
    }

    public void setSelectionModel(SingleSelectionModel model) {
        Assert.assertNotLocked(this);
        m_selection = model;
    }

    public final void lock() {
        m_locked = true;
    }

    public final boolean isLocked() {
        return m_locked;
    }
}
