/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.parameters;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.parameters.ParameterData;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.event.ParameterEvent;
import com.arsdigita.util.Assert;

/**
 *  Verifies that the
 * string length is less than or equal to the specified value
 *
 * @author Stanislav Freidin 
 * @version $Revision: #9 $ $Author: dennis $ $DateTime: 2004/04/07 16:07:11 $
 */
public class StringLengthValidationListener implements ParameterListener {
    public final static String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/bebop/parameters/StringLengthValidationListener.java#9 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private final int m_maxLength;
    private final String m_errHead;

    public static final StringLengthValidationListener FOUR_K = new StringLengthValidationListener(4000);

    public StringLengthValidationListener(final int maxLength) {
        Assert.truth(maxLength > 0, "Max length must be greater than 0");
        m_maxLength = maxLength;
        m_errHead = "The following strings are longer than " + maxLength +
            " characters: ";
    }

    public void validate(ParameterEvent e) throws FormProcessException {

        ParameterData data = e.getParameterData();
        Object obj = data.getValue();

        // Another listener will validate that these values are
        // present if required, but we don't want any null pointer
        // exceptions.
        if (obj == null) {
            return;
        }

        boolean isValid = true;
        String value = "";
        if (obj instanceof String[]) {
            String[] values = (String[]) obj;

            for (int i = 0; i < values.length && isValid; i++) {
                value = values[i];
                isValid = isValid(value);
            }
        } else {
            try {
                value = (String) obj;
                isValid = isValid(value);
            } catch (ClassCastException cce) {
                throw new FormProcessException(cce.getMessage(), cce);
            }
        }


        if (!isValid) {
            StringBuffer msg = new StringBuffer(m_errHead);
            msg.append("'").append(value).append("' ");
            data.addError(msg.toString());
        }
    }

    /**
     *
     * @param value String's length to validate
     * @return false if > m_max_length
     */
    private boolean isValid(final String value) {
        final int length = value.length();
        return length <= m_maxLength;
    }

}
