/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.list;

import com.arsdigita.util.Lockable;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.List;

/**
 * Produce a new {@link ListModel ListModels} for each
 * request. The builder will often run a database query, constructed from
 * request specific information in the <code>state</code> variable passed
 * to {@link #makeModel makeModel} and wrap the result set in a lightweight
 * implementation of <code>ListModel</code>.
 *
 * <p> The <code>ListModelBuilder</code> is used by the {@link List}
 * component whenever it needs to service a request: it calls
 * <code>makeModel</code> on the builder to generate a request-specific
 * <code>ListModel</code> which it then uses for outputting the items in
 * the list.
 *
 * <p> <b>Warning:</b> The signature of <code>makeModel</code> will be
 * changed to <code>ListModel makeModel(List, PageState)</code> after ACS
 * 4.6 </p>
 *
 * @author David Lutterkort
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/list/ListModelBuilder.java#8 $ */
public interface ListModelBuilder extends Lockable {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/list/ListModelBuilder.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     *  Produce a {@link
     * ListModel} for the request specified by <code>state</code>. This
     * method is called at least once, and usually only once, for each
     * request served by the {@link List} that this
     * <code>ListModelBuilder</code> has been added to.
     *
     * @param state contains the request specific data for the request
     * @return the abstract representation of the list item for this request */
    ListModel makeModel(List l, PageState state);

}
