/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.jsp;



/**
 * JSP tag handler to show contents from a model-backed Table.
 * <p>
 * Usage:
 * <pre>
 * &lt;show:table name="mylist"/>
 * </pre>
 * ... displays the list at this point in the JSP with global styling
 * for the list and its contents.  Or,
 *
 *  <pre>
 * &lt;show:table name="table">
 *    &lt;show:thead> &lt!-- iterates over table header columns -->
 *      column header: &lt;show:col/> :column header
 *    &lt;/show:thead>
 *    &lt;show:tbody> &lt!-- iterates over table rows -->
 *      table row starts here:
 *         &lt;show:row>
 *            table column: &lt;show:col/> :table column
 *         &lt;/show:row>
 *      :table row ends here
 *    &lt;/show:tbody>
 * &lt;/show:table>
 * </pre>
 *
 * ... has the effect of locally-styling the table contents in the JSP,
 * while globally styling the individual components inside the table
 * if there is a TableCellRenderer involved.
 * <p>
 * Note that a Bebop Table isn't really a Container, but from the JSP's
 * perspective of manipulating Bebop XML output, and not the components
 *  themselves, the behavior is container-like.
 */
public class ShowTable extends ShowContainer {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/jsp/ShowTable.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    // maybe this is just a synonym for ShowContainer?
    // ShowContainer sets up our input context...
}
