/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.jsp;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.globalization.GlobalizedMessage;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;

/**
 * Class for defining an option within a radio/checkbox/select group.
 * usage:
 * <pre>
 *    &lt;define:option name="label" value="value"/>
 * </pre>
 *
 * The "label" attribute is what is displayed to the user.  This
 * text may be globalized:
 *
 * <pre>
 *    &lt;define:option name="msg.key" bundle="com.arsdigita.MyBundleName"
 value="value"/>
 * </pre>
 */

public class DefineOption extends DefineComponent {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/jsp/DefineOption.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private Option m_option;
    private String m_value;
    private boolean m_selected;
    private String m_bundleName;

    /**
     * overrides superclass. we're not in a Container but we need to add
     * ourselves to an option group instead.
     */
    public int doStartTag() throws JspException {
        m_option = new Option(getName());
        if (m_value != null) {
            m_option.setValue(m_value);
        }
        if (m_bundleName != null) {
            // globalized message
            GlobalizedMessage gm =
                new GlobalizedMessage(getName(), m_bundleName);
            m_option.setLabel(new Label(gm));
        }
        Tag t = findAncestorWithClass(this, DefineOptionGroup.class);
        DefineOptionGroup dog = ((DefineOptionGroup)t);
        dog.addOption(m_option);
        if (m_selected) {
            dog.selectOption(m_option);
        }
        dog.doAfterBody();
        return EVAL_BODY_TAG;
    }

    protected final Component getComponent() {
        return m_option;
    }

    public final void setValue(String s) {
        m_value = s;
    }

    /**
     * If <code>s</code> is "true" then this option is selected by default.
     * @param s if "true", this option is selected.
     */
    public final void setSelected(String s) {
        if (s.equals("true") || s.equals("yes") || s.equals("selected")) {
            m_selected = true;
        }
    }

    /**
     * Sets the bundle name to use for globalizing this option's label.
     * @param s the fully-qualified resource bundle name.
     */
    public final void setBundle(String s) {
        m_bundleName = s;
    }
}
