/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.jsp;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import javax.servlet.jsp.JspException;

public class DefineForm extends DefineContainer {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/jsp/DefineForm.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private Form m_form;
    private String m_encType;
    private String m_onSubmit;
    private String m_onReset;
    private String m_method;
    private String m_action;

    public int doStartTag() throws JspException {
        m_form = new Form(getName());
        if (m_encType != null) {
            m_form.setEncType(m_encType);
        }
        if (m_onSubmit != null) {
            m_form.setOnSubmit(m_onSubmit);
        }
        if (m_onReset != null) {
            m_form.setOnReset(m_onReset);
        }
        if (m_method != null) {
            m_form.setMethod(m_method);
        }
        if (m_action != null) {
            m_form.setAction(m_action);
        }
        // add form to parent
        return super.doStartTag();
    }

    protected final Component getComponent() {
        return m_form;
    }

    /**
     * Sets the encoding type (multipart/form-data, etc.) for the form
     * when posted.
     */
    public final void setEncType(String s) {
        m_encType = s;
    }

    /**
     * sets the browser-side script code to run on form submit.
     */
    public final void setOnSubmit(String s) {
        m_onSubmit = s;
    }

    /**
     * sets the browser-side script code to run on form reset.
     */
    public final void setOnReset(String s) {
        m_onReset = s;
    }

    /**
     * sets the HTTP method for the request on form submission, e.g.,
     * "POST", "GET".   This defaults to GET.
     */
    public final void setMethod(String s) {
        m_method = s;
    }

    /**
     * sets the URL to POST or GET on form submission.  Defaults
     * to the same page that contains the form.
     */
    public final void setAction(String s) {
        m_action = s;
    }
}
