/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.form;

import com.arsdigita.bebop.parameters.ArrayParameter;
// This interface contains the XML element name of this class
// in a constant which is used when generating XML
import com.arsdigita.bebop.util.BebopConstants;

/**
 *     A class
 *    representing an HTML <code>SELECT</code> element.
 *
 *    @author Karl Goldstein 
 *    @author Uday Mathur 
 *    @author Rory Solomon 
 *    @author Michael Pih 
 *    @version $Id: //core-platform/dev/src/com/arsdigita/bebop/form/MultipleSelect.java#8 $ */
public class MultipleSelect extends Select implements BebopConstants {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/form/MultipleSelect.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public MultipleSelect(String name) {
        super(new ArrayParameter(name));
    }

    /** State that this is a multiple select
     *  @return true
     */
    public boolean isMultiple()
    { return true; }

    /** The XML tag for this derived class of Widget. */

    protected String getElementTag() {
        return BEBOP_MULTISELECT;
    }

}
