/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.form;

import com.arsdigita.bebop.event.ParameterEvent;
import com.arsdigita.bebop.parameters.GlobalizedParameterListener;
import com.arsdigita.bebop.parameters.ParameterData;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.dispatcher.MultipartHttpServletRequest;
import com.arsdigita.globalization.GlobalizedMessage;

import javax.servlet.http.HttpServletRequest;


/**
 * A class representing a file upload widget.
 *
 * @author Karl Goldstein 
 * @author Uday Mathur 
 * @author Stas Freidin 
 * @author Rory Solomon 
 * @author Michael Pih 
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/form/FileUpload.java#8 $ */

public class FileUpload extends Widget {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/form/FileUpload.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public FileUpload(String name) {
        this(name, true);
    }

    public FileUpload(String name, boolean validateInputFile) {
        super(name);
        addValidationListener(new FileExistsValidationListener());
    }

    public FileUpload(ParameterModel model) {
        this(model, true);
    }

    public FileUpload(ParameterModel model, boolean validateInputFile) {
        super(model);
        addValidationListener(new FileExistsValidationListener());
    }

    /**
     *      Returns a string naming the type of this widget.
     */
    public String getType() {
        return "file";
    }

    public boolean isCompound() {
        return false;
    }

    /**
     *      Callback method for rendering this File widget in a visitor.
     */
    /*  public void accept(FormVisitor visitor) throws IOException {
        visitor.visitFile(this);
        }*/

    private class FileExistsValidationListener extends GlobalizedParameterListener {
        
        public FileExistsValidationListener() {
            setError(new GlobalizedMessage("file_empty_or_not_found", getBundleBaseName()));
        }
        
        public void validate (ParameterEvent e) {
            ParameterData data = e.getParameterData();
            HttpServletRequest request = e.getPageState().getRequest();
            String filename = (String) data.getValue();
            
            if (!(request instanceof MultipartHttpServletRequest) || 
                filename == null || 
                filename.length() == 0) {
                return;
            }
            
            if (((MultipartHttpServletRequest) request).getFile(data.getModel().getName()).length()==0) {
                data.addError(filename + " " + getError().localize());
            }
        }
    }
}
