/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.form;


import com.arsdigita.xml.Element;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.form.Widget;
import com.arsdigita.bebop.parameters.ParameterModel;
// This interface contains the XML element name of this class
// in a constant which is used when generating XML
import com.arsdigita.bebop.util.BebopConstants;



/**
 *    A class representing a textarea field in an HTML form.
 *
 *    @deprecated See {@link DHTMLEditor}
 *    @author Jim Parsons
 */
public class Deditor extends Widget implements BebopConstants {


    /**
     * Constant for specifying <tt>OFF</tt> value for the
     * <tt>WRAP</tt> attribute of this image input.  See <a
     * href="http://developer.netscape.com/docs/manuals/htmlguid/tags10.htm#1340340">here</a>
     * for a description of what this attribute does.  */

    public static final int OFF = 0;

    /**
     * Constant for specifying <tt>HARD</tt> value for the
     * <tt>WRAP</tt> attribute of this image input.  * See <a
     * //href="http://developer.netscape.com/docs/manuals/htmlguid/tags10.htm#1340340">here</a>
     * for a description of what this attribute does.
     */
    public static final int HARD = 1;

    /**
     * Constant for specifying <tt>SOFT</tt> value for the
     * <tt>WRAP</tt> attribute of this image input.  See <a
     * href="http://developer.netscape.com/docs/manuals/htmlguid/tags10.htm#1340340">here</a>
     * for a description of what this attribute does.
     */
    public static final int SOFT = 2;

    public Deditor(String name) {
        super(name);
    }

    public Deditor(ParameterModel model) {
        super(model);
    }


    /**
     *      Returns a string naming the type of this widget.
     */
    public String getType() {
        return "deditor";
    }


    /**
     * Set the default value (text)
     * @deprecated [since 17Aug2001] use {@link Widget#setDefaultValue(Object)}
     */
    public void setValue( String text ) {
        this.setDefaultValue(text);
    }

    /**
     *      Sets the <tt>ROWS</tt> attribute for the <tt>TEXTAREA</tt> tag.
     */
    public void setRows(int rows) {
        setAttribute("rows", String.valueOf(rows));
    }

    /**
     *      Sets the <tt>COLS</tt> attribute for the <tt>TEXTAREA</tt> tag.
     */
    public void setCols(int cols) {
        setAttribute("cols", String.valueOf(cols));
    }

    /**
     *      Sets the <tt>COLS</tt> attribute for the <tt>TEXTAREA</tt> tag.
     */
    public void setWrap(int wrap) {
        String wrapString = null;

        switch (wrap) {
        case OFF:
            wrapString = "off";
            break;
        case HARD:
            wrapString = "hard";
            break;
        case SOFT:
            wrapString = "soft";
            break;
        }

        if (wrapString != null) {
            setAttribute("wrap", wrapString);
        }
    }

    /**
     * Is this a compound widget?
     * @return false
     */
    public boolean isCompound() {
        return false;
    }

    /** The XML tag.
     *  @return The tag to be used for the top level DOM element
     *  generated for this type of Widget.  */
    protected String getElementTag() {
        return "bebop:deditor";
    }

    /**
     * Generates the DOM for the textarea widget
     * <p>Generates DOM fragment:
     * <p><code>&lt;bebop:textarea name=... value=... [onXXX=...]/>
     *  </code>
     */
    public void generateWidget( PageState state, Element parent ) {

        Element deditor = parent.newChildElement(getElementTag(), BEBOP_XML_NS);

        deditor.addAttribute("name", getName());

        String userAgent =
            state.getRequest().getHeader("user-agent").toLowerCase();
        boolean isIE55 =
            (userAgent != null &&
             ((userAgent.indexOf("msie 5.5") != -1) ||
              (userAgent.indexOf("msie 6") != -1)));

        deditor.addAttribute("isIE55", (new Boolean(isIE55)).toString());


        String value = getParameterData(state).marshal();
        if ( value == null ) {
            value = "";
        }
        Element texter = deditor.newChildElement("bebop:textcontent",BEBOP_XML_NS);
        texter.setCDATASection(value);
        exportAttributes(deditor);
    }

}
