/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.event;

import java.util.EventListener;

/**
 * The listener that is notified when a tree node is expanded or
 * collapsed.
 *
 * @author David Lutterkort
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/event/TreeExpansionListener.java#7 $
 */
public interface TreeExpansionListener extends EventListener {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/event/TreeExpansionListener.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Called whenever an item in the tree has been collapsed.
     */
    void treeCollapsed(TreeExpansionEvent event);

    /**
     * Called whenever an item in the tree has been expanded.
     */
    void treeExpanded(TreeExpansionEvent event);

}
