/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.event;

/**
 * An implentation of the TableActionListener interface meant to save the
 * developer from having to override both the {@link
 * #cellSelected(TableActionEvent)} and {@link #headSelected(TableActionEvent)}
 * methods when they only need to change the behavior of one.
 *
 * @see TableActionEvent
 * @author David Lutterkort
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/event/TableActionAdapter.java#9 $
 */
public class TableActionAdapter implements TableActionListener {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/event/TableActionAdapter.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * A no-op implementation of {@link
     * TableActionListener#cellSelected(TableActionEvent)}.
     *
     * @param e the event fired for the table.
     */
    public void cellSelected(TableActionEvent e) {
        return;
    }

    /**
     * A no-op implementation of {@link
     * TableActionListener#headSelected(TableActionEvent)}.
     *
     * @param e the event fired for the table.
     */
    public void headSelected(TableActionEvent e) {
        return;
    }
}
