/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.event;

/**
 *  Listener interface for
 * the SeachAndSelect Bebop widget.  SearchAndSelect requires
 * knowledge about the data it is searching over (to determine the
 * display method and to actually execute the query).
 *
 * @author Patrick McNeill
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/event/SearchAndSelectModel.java#8 $
 * @since 4.5 */
public interface SearchAndSelectModel {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/event/SearchAndSelectModel.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    /**
     * Specify the user's search and restrict the result set to those queries
     * that match.  An empty string should return all results.
     *
     * @param query the user's search string, space or comma delimited words
     */
    void setQuery ( String query );

    /**
     * Retrieve the query that was last used.
     *
     * @return the query string
     */
    String getQuery ();

    /**
     * Return the number of items that are currently selected by the query
     * string.  If the query string is empty, this should return the number
     * of items in the dataset.
     *
     * @return the number of currently selected items
     */
    int resultsCount ();

    /**
     * Get the "i"th label (0 based indexing)
     *
     * @param i the label number to retrieve
     * @return the ith label
     */
    String getLabel (int i);

    /**
     * Get the "i"th ID (0 based indexing)
     *
     * @param i the ID number to retrieve
     * @return the ith ID
     */
    String getID (int i);
}
