/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.event;

import com.arsdigita.bebop.PageState;

/**
 * An event originating from a component. <code>PrintEvent</code>s are
 * fired just before the <code>source</code> component is output either as
 * part of an XML document or as part of an HTML page.
 *
 * @see PrintListener
 *
 * @author Uday Mathur
 * @author David Lutterkort
 *
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/event/PrintEvent.java#8 $
 *
 */
public class PrintEvent extends PageEvent {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/event/PrintEvent.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private Object m_target;

    /**
     * Construct a <code>PrintEvent</code>
     *
     * @param source the object that originated the event
     * @param data the data for the parameter from the current request
     * @pre source != null
     * @pre target != null
     */
    public PrintEvent(Object source,  PageState state, Object target) {
        super(source, state);
        m_target = target;
    }

    /**
     * Get the target object, the one that can be freely modified by print
     * listeners. Initially, the target is an unlocked clone of the source of
     * the event.
     * @post return != null
     */
    public final Object getTarget() {
        return m_target;
    }

}
