/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.event;

import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.PageState;

/**
 * An event originating from a form. <code>FormSectionEvent</code>s are
 * used to notify listeners that values in a form should be initilialized,
 * validated or processed.
 *
 * @author David Lutterkort 
 *
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/event/FormSectionEvent.java#7 $
 *
 * @see FormInitListener
 * @see FormValidationListener
 * @see FormProcessListener
 */
public class FormSectionEvent extends PageEvent {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/event/FormSectionEvent.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private transient FormData _formData;

    /**
     * Get the form data for to the form that fired the event in the current
     * request.
     */
    public final FormData getFormData() {
        return _formData;
    }

    /**
     * Construct a <code>FormSectionEvent</code>.
     *
     * @param source the form model that fired the event
     * @param state  the state of the enclosing page
     * @param formData the form data constructed so far
     */
    public FormSectionEvent(Object source, PageState state,
                            FormData formData) {
        super(source, state);
        _formData = formData;
    }

}
