/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.event;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;

/**
 * A component-defined event. Components usually fire an
 * <code>ActionEvent</code> to indicate that they were the ones receiving
 * the click in a user's submission, for example, a form might use an
 * <code>ActionEvent</code> to signal that it has been submitted.
 *
 * @author David Lutterkort 
 *
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/event/ActionEvent.java#7 $
 *
 * @see ActionListener
 * @see java.awt.event.ActionEvent
 */

public class ActionEvent extends PageEvent {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/event/ActionEvent.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Construct an <code>ActionEvent</code>.
     *
     * @param source the component that originated the event
     * @param state  the state of the containing page under the current
     * request
     */
    public ActionEvent(Component source, PageState state) {
        super(source, state);
    }

}
