/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.demo;


import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.demo.workflow.AdminPane;
import com.arsdigita.bebop.demo.workflow.Listing;


public class WorkflowAdminPage extends Page {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/demo/WorkflowAdminPage.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public WorkflowAdminPage() {
        super("Workflow Mockup", makePanel());

        String title = "Workflow Templates Control Center";

        setTitle(title);
        Label t = new Label(title);
        t.setFontWeight(Label.BOLD);
        add(t, ColumnPanel.FULL_WIDTH | ColumnPanel.LEFT);

        Listing listing = new Listing();
        SingleSelectionModel m = listing.getList().getSelectionModel();
        add(listing, ColumnPanel.TOP);
        add(new AdminPane(m, listing.getAddLink()));
    }

    private static ColumnPanel makePanel() {
        ColumnPanel result = new ColumnPanel(2);
        result.setColumnWidth(1, "25%");
        result.setBorder(false);
        result.setPadColor("white");
        result.setPadBorder(true);
        return result;
    }

}
