/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop;

import com.arsdigita.bebop.form.Submit;


public class YesNoSection extends FormSection {
    private Submit m_yes;
    private Submit m_no;

    public YesNoSection() {
        super(new BoxPanel(BoxPanel.HORIZONTAL, false));

        BoxPanel panel = (BoxPanel)getPanel();
        panel.setWidth("2%");

        // Submit widgets
        m_yes = new Submit("yes");
        m_yes.setButtonLabel("Yes");
        add(m_yes, BoxPanel.RIGHT);

        m_no = new Submit("no");
        m_no.setButtonLabel("No");
        add(m_no, BoxPanel.RIGHT);
    }

    public boolean yesPressed(PageState state) {
        return m_yes.isSelected(state);
    }

    public boolean noPressed(PageState state) {
        return m_no.isSelected(state);
    }
}
